<?php

namespace Database\Factories\Entities\Models;

use BookStack\Entities\Tools\PageEditorType;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class PageFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \BookStack\Entities\Models\Page::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $html = '<p>' . implode('</p>', $this->faker->paragraphs(5)) . '</p>';

        return [
            'name'           => $this->faker->sentence(),
            'slug'           => Str::random(10),
            'html'           => $html,
            'text'           => strip_tags($html),
            'revision_count' => 1,
            'editor'         => 'wysiwyg',
            'priority'       => 1,
        ];
    }
}
