<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        // Add API tokens table
        Schema::create('api_tokens', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('token_id')->unique();
            $table->string('secret');
            $table->integer('user_id')->unsigned()->index();
            $table->date('expires_at')->index();
            $table->nullableTimestamps();
        });

        // Add access-api permission
        $adminRoleId = DB::table('roles')->where('system_name', '=', 'admin')->first()->id;
        $permissionId = DB::table('role_permissions')->insertGetId([
            'name'         => 'access-api',
            'display_name' => 'Access system API',
            'created_at'   => Carbon::now()->toDateTimeString(),
            'updated_at'   => Carbon::now()->toDateTimeString(),
        ]);
        DB::table('permission_role')->insert([
            'role_id'       => $adminRoleId,
            'permission_id' => $permissionId,
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove API tokens table
        Schema::dropIfExists('api_tokens');

        // Remove access-api permission
        $apiAccessPermission = DB::table('role_permissions')
            ->where('name', '=', 'access-api')->first();

        DB::table('permission_role')->where('permission_id', '=', $apiAccessPermission->id)->delete();
        DB::table('role_permissions')->where('name', '=', 'access-api')->delete();
    }
};
