<?php
/**
 * Settings text strings
 * Contains all text strings used in the general settings sections of BookStack
 * including users and roles.
 */
return [

    // Common Messages
    'settings' => 'الإعدادات',
    'settings_save' => 'حفظ الإعدادات',
    'system_version' => 'إصدار النظام',
    'categories' => 'التصنيفات',

    // App Settings
    'app_customization' => 'تخصيص',
    'app_features_security' => 'الميزات و الأمان',
    'app_name' => 'اسم التطبيق',
    'app_name_desc' => 'سيتم عرض هذا الاسم في الترويسة وفي أي رسالة بريد إلكتروني.',
    'app_name_header' => 'عرض اسم التطبيق في الترويسة؟',
    'app_public_access' => 'الوصول العام',
    'app_public_access_desc' => 'تمكين هذا الخيار سيسمح للزوار، الذين لم يتم تسجيل دخولهم، بالوصول إلى المحتوى في مثيل مكدس الكتب الخاص بك.',
    'app_public_access_desc_guest' => 'يمكن التحكم في وصول الزوار العموميين من خلال المستخدم "الضيف".',
    'app_public_access_toggle' => 'السماح بالوصول العام',
    'app_public_viewing' => 'السماح بالعرض على العامة؟',
    'app_secure_images' => 'تفعيل حماية أكبر لرفع الصور؟',
    'app_secure_images_toggle' => 'لمزيد من الحماية',
    'app_secure_images_desc' => 'لتحسين أداء النظام, ستكون جميع الصور متاحة للعامة. هذا الخيار يضيف سلسلة من الحروف والأرقام العشوائية صعبة التخمين إلى رابط الصورة. الرجاء التأكد من تعطيل فهرسة المسارات لمنع الوصول السهل.',
    'app_default_editor' => 'محرر الصفحة الافتراضي',
    'app_default_editor_desc' => 'حدد أي محرر سيتم استخدامه بشكل افتراضي عند تحرير صفحات جديدة. يمكن تجاوز هذا على مستوى الصفحة حيث تسمح الأذونات.',
    'app_custom_html' => 'Custom HTML head content',
    'app_custom_html_desc' => 'سيتم إدراج أي محتوى مضاف هنا في الجزء السفلي من قسم <head> من كل صفحة. هذا أمر مفيد لتجاوز الأنماط أو إضافة رمز التحليل.',
    'app_custom_html_disabled_notice' => 'تم تعطيل محتوى HTML الرئيسي المخصص في صفحة الإعدادات هذه لضمان عكس أي تغييرات متتالية.',
    'app_logo' => 'شعار التطبيق',
    'app_logo_desc' => 'يستخدم هذا في شريط رأس التطبيق، ضمن مجالات أخرى. يجب أن تكون هذه الصورة 86 بكسل في الطول. سيتم تقليص الصور الكبيرة.',
    'app_icon' => 'أيقونة التطبيق',
    'app_icon_desc' => 'يستخدم هذا الرمز لعلامات تبويب المتصفح والرموز المختصرة. يجب أن تكون هذه صورة PNG مربعة 256px.',
    'app_homepage' => 'الصفحة الرئيسية للتطبيق',
    'app_homepage_desc' => 'الرجاء اختيار صفحة لتصبح الصفحة الرئيسية بدل من الافتراضية. سيتم تجاهل جميع الأذونات الخاصة بالصفحة المختارة.',
    'app_homepage_select' => 'اختر صفحة',
    'app_footer_links' => 'روابط تذييل الصفحة',
    'app_footer_links_desc' => 'إضافة روابط لعرضها داخل تذييل الموقع. سيتم عرضها في أسفل معظم الصفحات، بما في ذلك تلك التي لا تتطلب تسجيل الدخول. يمكنك استخدام تسمية "trans::<key>لاستخدام الترجمات المحددة في النظام. على سبيل المثال: باستخدام "trans::common.privacy_policy" سيوفر النص المترجم "Privacy Policy" و "trans::common.terms_of_service" سيوفر النص المترجم "شروط الخدمة".',
    'app_footer_links_label' => 'تسمية الرابط',
    'app_footer_links_url' => 'عنوان الرابط',
    'app_footer_links_add' => 'إضافة رابط تذييل الصفحة',
    'app_disable_comments' => 'تعطيل التعليقات',
    'app_disable_comments_toggle' => 'تعطيل التعليقات',
    'app_disable_comments_desc' => 'تعطيل التعليقات على جميع الصفحات داخل التطبيق. التعليقات الموجودة من الأصل لن تكون ظاهرة.',

    // Color settings
    'color_scheme' => 'مخطط ألوان التطبيق',
    'color_scheme_desc' => 'حدّد الألوان المستخدمة في واجهة مستخدم التطبيق. يمكن ضبط الألوان بشكل منفصل للوضعين الداكن والفاتح لتناسب المظهر بشكل أفضل ولضمان وضوح النص.',
    'ui_colors_desc' => 'عيّن اللون الأساسي للتطبيق ولون الرابط الافتراضي. يُستخدم اللون الأساسي بشكل رئيس في شعار الصفحة الرئيسة والأزرار وزخارف الواجهة. أما اللون الافتراضي للرابط، فيُستخدم للروابط والإجراءات النصية، سواءً داخل المحتوى المكتوب أو في واجهة التطبيق.',
    'app_color' => 'اللون الأساسي',
    'link_color' => 'لون الرابط الافتراضي',
    'content_colors_desc' => 'حدّد ألوان جميع عناصر هيكل تنظيم الصفحة. يُنصح باختيار ألوان بنفس سطوع الألوان الافتراضية لسهولة القراءة.',
    'bookshelf_color' => 'لون الرف',
    'book_color' => 'لون الكتاب',
    'chapter_color' => 'لون الفصل',
    'page_color' => 'لون الصفحة',
    'page_draft_color' => 'لون مسودة الصفحة',

    // Registration Settings
    'reg_settings' => 'إعدادات التسجيل',
    'reg_enable' => 'تمكين التسجيل',
    'reg_enable_toggle' => 'تمكين التسجيل',
    'reg_enable_desc' => 'عند تمكين التسجيل سيكون المستخدم قادرا على تسجيل نفسه كمستخدم تطبيق. عند التسجيل يعطى لهم دور مستخدم افتراضي وحيد.',
    'reg_default_role' => 'دور المستخدم الأساسي بعد التسجيل',
    'reg_enable_external_warning' => 'يتم تجاهل الخيار أعلاه بينما يتم تفعيل مصادقة LDAP الخارجية أو SAML. حسابات المستخدم للأعضاء غير الحاليين سيتم إنشاؤها تلقائياً إذا كانت المصادقة، مقابل النظام الخارجي المستخدم، ناجحة.',
    'reg_email_confirmation' => 'تأكيد البريد الإلكتروني',
    'reg_email_confirmation_toggle' => 'يتطلب تأكيد البريد الإلكتروني',
    'reg_confirm_email_desc' => 'إذا تم استخدام قيود للمجال سيصبح التأكيد عن طريق البريد الإلكتروني إلزامي وسيتم تجاهل القيمة أسفله.',
    'reg_confirm_restrict_domain' => 'تقييد التسجيل على مجال محدد',
    'reg_confirm_restrict_domain_desc' => 'أدخل قائمة مفصولة بفواصل لنطاقات البريد الإلكتروني التي ترغب في تقييد التسجيل إليها. سيتم إرسال بريد إلكتروني للمستخدمين لتأكيد عنوانهم قبل السماح لهم بالتفاعل مع التطبيق. <br> لاحظ أن المستخدمين سيكونون قادرين على تغيير عناوين البريد الإلكتروني الخاصة بهم بعد التسجيل بنجاح.',
    'reg_confirm_restrict_domain_placeholder' => 'لم يتم اختيار أي قيود',

    // Sorting Settings
    'sorting' => 'القوائم و الفرز',
    'sorting_book_default' => 'ترتيب الكتاب الافتراضي',
    'sorting_book_default_desc' => 'حدد قاعدة الترتيب الافتراضية لتطبيقها على الكتب الجديدة. لن يؤثر هذا على الكتب الحالية، ويمكن تجاوزه لكل كتاب على حدة.',
    'sorting_rules' => 'قواعد الترتيب',
    'sorting_rules_desc' => 'هذه هي عمليات الترتيب المحددة مسبقًا الذي يمكن تطبيقها على المحتوى الموجود في النظام.',
    'sort_rule_assigned_to_x_books' => 'مُعيَّن إلى :count كتاب|مُعيَّن إلى :count كتاب',
    'sort_rule_create' => 'إنشاء قاعدة الترتيب',
    'sort_rule_edit' => 'تعديل قاعدة الترتيب',
    'sort_rule_delete' => 'حذف قاعدة الترتيب',
    'sort_rule_delete_desc' => 'أزل قاعدة الترتيب هذه من النظام. الكتب التي تستخدم هذا الفرز ستعود إلى الفرز اليدوي.',
    'sort_rule_delete_warn_books' => 'تُستخدم قاعدة الترتيب هذه حاليًا على :count كتاب/كتب. متيقن من رغبتك في حذف هذا؟',
    'sort_rule_delete_warn_default' => 'تُستخدم قاعدة الترتيب هذه حاليًا كإعداد افتراضي للكتب. متيقن من رغبتك في حذفها؟',
    'sort_rule_details' => 'تفاصيل قاعدة الترتيب',
    'sort_rule_details_desc' => 'تعيين اسم لقاعدة الترتيب هذه، التي ستظهر في القوائم عندما يقوم المستخدمون باختيار نوع ما.',
    'sort_rule_operations' => 'عمليات الترتيب',
    'sort_rule_operations_desc' => 'جهّز إجراءات الترتيب المطلوب تنفيذها بنقلها من قائمة العمليات المتاحة. عند الاستخدام، سيتم تطبيق العمليات بالترتيب من الأعلى إلى الأسفل. أي تغييرات تُجرى هنا ستُطبّق على جميع الكتب المُخصّصة عند الحفظ.',
    'sort_rule_available_operations' => 'العمليات المتاحة',
    'sort_rule_available_operations_empty' => 'لا توجد عمليات متبقية',
    'sort_rule_configured_operations' => 'العمليات المُهيأة',
    'sort_rule_configured_operations_empty' => 'اسحب/أضف العمليات من قائمة "العمليات المتاحة"',
    'sort_rule_op_asc' => '(تصاعدي)',
    'sort_rule_op_desc' => '(تنازلي)',
    'sort_rule_op_name' => 'الاسم - أبجديًا',
    'sort_rule_op_name_numeric' => 'الاسم - رقمي',
    'sort_rule_op_created_date' => 'تاريخ الإنشاء',
    'sort_rule_op_updated_date' => 'تاريخ التحديث',
    'sort_rule_op_chapters_first' => 'الفصول الأولى',
    'sort_rule_op_chapters_last' => 'الفصول الأخيرة',
    'sorting_page_limits' => 'حدود العرض لكل صفحة',
    'sorting_page_limits_desc' => 'تعيين عدد العناصر لإظهار كل صفحة في قوائم مختلفة داخل النظام. عادةً ما يكون الرقم الأقل هو الأكثر أداء، بينما وضع رقم أعلى يغني عن النقر على صفحات متعددة. يوصى باستخدام مضاعفات رقم ٣ (18 و 24 و 30 و إلخ...).',

    // Maintenance settings
    'maint' => 'الصيانة',
    'maint_image_cleanup' => 'تنظيف الصور',
    'maint_image_cleanup_desc' => 'مسح الصفحة ومراجعة المحتوى للتحقق من أي الصور والرسوم المستخدمة حاليًا وأي الصور زائدة عن الحاجة. تأكد من إنشاء قاعدة بيانات كاملة و نسخة احتياطية للصور قبل تشغيل هذا.',
    'maint_delete_images_only_in_revisions' => 'قم أيضًا بحذف الصور الموجودة فقط في مراجعات الصفحة القديمة',
    'maint_image_cleanup_run' => 'بدء التنظيف',
    'maint_image_cleanup_warning' => 'يوجد عدد :count من الصور المحتمل عدم استخدامها. تأكيد حذف الصور؟',
    'maint_image_cleanup_success' => 'تم إيجاد وحذف عدد :count من الصور المحتمل عدم استخدامها!',
    'maint_image_cleanup_nothing_found' => 'لم يتم حذف أي شيء لعدم وجود أي صور غير مسمتخدمة',
    'maint_send_test_email' => 'إرسال بريد إلكتروني تجريبي',
    'maint_send_test_email_desc' => 'يرسل هذا بريدًا إلكترونيًا تجريبيًا إلى عنوان بريدك الإلكتروني المحدد في ملفك الشخصي.',
    'maint_send_test_email_run' => 'إرسال بريد إليكتروني تجريبي',
    'maint_send_test_email_success' => 'تم إرسال البريد الإلكتروني إلى:العنوان',
    'maint_send_test_email_mail_subject' => 'اختبار البريد الإلكتروني',
    'maint_send_test_email_mail_greeting' => 'يبدو أن تسليم البريد الإلكتروني يعمل!',
    'maint_send_test_email_mail_text' => 'تهانينا! كما تلقيت إشعار هذا البريد الإلكتروني، يبدو أن إعدادات البريد الإلكتروني الخاص بك قد تم تكوينها بشكل صحيح.',
    'maint_recycle_bin_desc' => 'تُرسل الأرفف والكتب والفصول والصفحات المحذوفة إلى سلة المحذوفات حتى يمكن استعادتها أو حذفها نهائيًا. قد يتم إزالة العناصر الأقدم في سلة المحذوفات تلقائيًا بعد فترة اعتمادًا على تكوين النظام.',
    'maint_recycle_bin_open' => 'افتح سلة المحذوفات',
    'maint_regen_references' => 'إعادة إنشاء المراجع',
    'maint_regen_references_desc' => 'سيعيد هذا الإجراء بناء فِهْرِس المراجع بين العناصر داخل قاعدة البيانات. عادةً ما يتم ذلك تلقائيًا، ولكنه قد يكون مفيدًا لفهرسة المحتوى القديم أو المحتوى المُضاف بطرق غير رسمية.',
    'maint_regen_references_success' => 'لقد تم تجديد فِهْرِس المرجع!',
    'maint_timeout_command_note' => 'ملاحظة: قد يستغرق تنفيذ هذا الإجراء بعض الوقت، مما قد يؤدي إلى مشاكل في مهلة التنفيذ في بعض بيئات الويب. كبديل، يمكن تنفيذ هذا الإجراء باستخدام سطر الأوامر.',

    // Recycle Bin
    'recycle_bin' => 'سلة المحذوفات',
    'recycle_bin_desc' => 'هنا يمكنك استعادة العناصر التي تم حذفها أو اختيار إزالتها نهائيا من النظام. هذه القائمة غير مصفاة خلافاً لقوائم الأنشطة المماثلة في النظام حيث يتم تطبيق عوامل تصفية الأذونات.',
    'recycle_bin_deleted_item' => 'عنصر محذوف',
    'recycle_bin_deleted_parent' => 'اﻷب',
    'recycle_bin_deleted_by' => 'حُذف بواسطة',
    'recycle_bin_deleted_at' => 'وقت الحذف',
    'recycle_bin_permanently_delete' => 'حُذف نهائيًا',
    'recycle_bin_restore' => 'استرجاع',
    'recycle_bin_contents_empty' => 'سلة المحذوفات فارغة حاليًا',
    'recycle_bin_empty' => 'إفراغ سلة المحذوفات',
    'recycle_bin_empty_confirm' => 'سيؤدي هذا إلى إتلاف جميع العناصر الموجودة في سلة المحذوفات بشكل دائم بما في ذلك المحتوى الموجود داخل كل عنصر. هل أنت متأكد من أنك تريد إفراغ سلة المحذوفات؟',
    'recycle_bin_destroy_confirm' => 'سيؤدي هذا الإجراء إلى حذف هذا العنصر نهائيًا من النظام، بالإضافة إلى أي عناصر فرعية مدرجة أدناه، ولن تتمكن من استعادة هذا المحتوى. هل أنت متيقِّن من رغبتك في حذف هذا العنصر نهائيًا؟',
    'recycle_bin_destroy_list' => 'العناصر المراد تدميرها',
    'recycle_bin_restore_list' => 'العناصر المراد استرجاعها',
    'recycle_bin_restore_confirm' => 'سيعيد هذا الإجراء العنصر المحذوف ، بما في ذلك أي عناصر فرعية ، إلى موقعه الأصلي. إذا تم حذف الموقع الأصلي منذ ذلك الحين ، وهو الآن في سلة المحذوفات ، فسيلزم أيضًا استعادة العنصر الأصلي.',
    'recycle_bin_restore_deleted_parent' => 'تم حذف أصل هذا العنصر أيضًا. سيبقى حذفه حتى يتم استعادة ذلك الأصل أيضًا.',
    'recycle_bin_restore_parent' => 'استعادة اﻷب',
    'recycle_bin_destroy_notification' => 'المحذوف: قُم بعد إجمالي العناصر من سلة المحذوفات.',
    'recycle_bin_restore_notification' => 'المرتجع: قُم بعد إجمالي العناصر من سلة المحذوفات.',

    // Audit Log
    'audit' => 'سجل المراجعة',
    'audit_desc' => 'يعرض هذا السجل قائمة بالأنشطة المتعقبة في النظام. هذه القائمة غير مصفاة خلافاً لقوائم الأنشطة المماثلة في النظام حيث يتم تطبيق عوامل تصفية الأذونات.',
    'audit_event_filter' => 'تصفية الحدث',
    'audit_event_filter_no_filter' => 'لا يوجد فلتر',
    'audit_deleted_item' => 'عنصر محذوف',
    'audit_deleted_item_name' => 'الاسم: كتابة الاسم',
    'audit_table_user' => 'المستخدم',
    'audit_table_event' => 'الحدث',
    'audit_table_related' => 'العنصر أو التفاصيل ذات الصلة',
    'audit_table_ip' => 'عنوان عُرف اﻹنترنت -IP-',
    'audit_table_date' => 'تاريخ النشاط',
    'audit_date_from' => 'نطاق التاريخ من',
    'audit_date_to' => 'نطاق التاريخ إلى',

    // Role Settings
    'roles' => 'الأدوار',
    'role_user_roles' => 'أدوار المستخدمين',
    'roles_index_desc' => 'تُستخدم الأدوار لتجميع المستخدمين ومنح أذونات النظام لأعضائها. عندما يكون المستخدم عضوًا في أدوار متعددة، تتراكم الصلاحيات الممنوحة، ويرث المستخدم جميع القدرات.',
    'roles_x_users_assigned' => ':count مستخدم معين|:count مستخدمين معينين',
    'roles_x_permissions_provided' => ':count إذن |:count إذونات',
    'roles_assigned_users' => 'المستخدمون المعينون',
    'roles_permissions_provided' => 'الصلاحيات المقدمة',
    'role_create' => 'إنشاء دور جديد',
    'role_delete' => 'حذف الدور',
    'role_delete_confirm' => 'سيتم حذف الدور المسمى \':roleName\'.',
    'role_delete_users_assigned' => 'هذا الدور له: عدد المستخدمين المعينين له. إذا كنت ترغب في ترحيل المستخدمين من هذا الدور ، فحدد دورًا جديدًا أدناه.',
    'role_delete_no_migration' => "لا تقم بترجيل المستخدمين",
    'role_delete_sure' => 'تأكيد حذف الدور؟',
    'role_edit' => 'تعديل الدور',
    'role_details' => 'تفاصيل الدور',
    'role_name' => 'اسم الدور',
    'role_desc' => 'وصف مختصر للدور',
    'role_mfa_enforced' => 'يتطلب مصادقة متعددة العوامل',
    'role_external_auth_id' => 'ربط الحساب بمواقع التواصل',
    'role_system' => 'أذونات النظام',
    'role_manage_users' => 'إدارة المستخدمين',
    'role_manage_roles' => 'إدارة الأدوار وأذوناتها',
    'role_manage_entity_permissions' => 'إدارة جميع أذونات الكتب والفصول والصفحات',
    'role_manage_own_entity_permissions' => 'إدارة الأذونات الخاصة بكتابك أو فصلك أو صفحاتك',
    'role_manage_page_templates' => 'إدارة قوالب الصفحة',
    'role_access_api' => 'الوصول إلى واجهة برمجة تطبيقات النظام API',
    'role_manage_settings' => 'إدارة إعدادات التطبيق',
    'role_export_content' => 'تصدير المحتوى',
    'role_import_content' => 'استيراد المحتوى',
    'role_editor_change' => 'تغيير محرر الصفحة',
    'role_notifications' => 'تلقي الإشعارات وإدارتها',
    'role_permission_note_users_and_roles' => 'These permissions will technically also provide visibility & searching of users & roles in the system.',
    'role_asset' => 'أذونات الأصول',
    'roles_system_warning' => 'اعلم أن الوصول إلى أي من الأذونات الثلاثة المذكورة أعلاه يمكن أن يسمح للمستخدم بتغيير امتيازاته الخاصة أو امتيازات الآخرين في النظام. قم بتعيين الأدوار مع هذه الأذونات فقط للمستخدمين الموثوق بهم.',
    'role_asset_desc' => 'تتحكم هذه الأذونات في الوصول الافتراضي إلى الأصول داخل النظام. ستتجاوز الأذونات الخاصة بالكتب والفصول والصفحات هذه الأذونات.',
    'role_asset_admins' => 'يُمنح المسؤولين حق الوصول تلقائيًا إلى جميع المحتويات ولكن هذه الخيارات قد تعرض خيارات واجهة المستخدم أو تخفيها.',
    'role_asset_image_view_note' => 'يتعلق هذا بالرؤية داخل مدير الصور. يعتمد الوصول الفعلي لملفات الصور المُحمّلة على خِيار تخزين الصور في النظام.',
    'role_asset_users_note' => 'These permissions will technically also provide visibility & searching of users in the system.',
    'role_all' => 'الكل',
    'role_own' => 'ما يخص',
    'role_controlled_by_asset' => 'يتحكم فيها الأصول التي يتم رفعها إلى',
    'role_save' => 'حفظ الدور',
    'role_users' => 'مستخدمون داخل هذا الدور',
    'role_users_none' => 'لم يتم تعيين أي مستخدمين لهذا الدور',

    // Users
    'users' => 'المستخدمون',
    'users_index_desc' => 'إنشاء وإدارة حسابات المستخدمين الفردية داخل النظام. يتم استخدام حسابات المستخدم لتسجيل الدخول وإسناد المحتوى والنشاط. صلاحيات الوصول هي أساسا قائمة على الأدوار ولكن ملكية محتوى المستخدم، من بين عوامل أخرى، قد تؤثر أيضا على صلاحيات والوصول إليها.',
    'user_profile' => 'ملف المستخدم',
    'users_add_new' => 'إضافة مستخدم جديد',
    'users_search' => 'بحث عن مستخدم',
    'users_latest_activity' => 'أحدث نشاط',
    'users_details' => 'بيانات المستخدم',
    'users_details_desc' => 'قم بتعيين اسم عرض وعنوان بريد إلكتروني لهذا المستخدم. سيتم استخدام عنوان البريد الإلكتروني لتسجيل الدخول إلى التطبيق.',
    'users_details_desc_no_email' => 'قم بتعيين اسم عرض لهذا المستخدم حتى يتمكن الآخرون من التعرف عليه.',
    'users_role' => 'أدوار المستخدمين',
    'users_role_desc' => 'حدد الأدوار التي سيتم تعيين هذا المستخدم لها. إذا تم تعيين مستخدم لأدوار متعددة ، فسيتم تكديس الأذونات من هذه الأدوار وسيتلقى كل قدرات الأدوار المعينة.',
    'users_password' => 'كلمة مرور المستخدم',
    'users_password_desc' => 'عيّن كلمة سر لتسجيل الدخول إلى التطبيق. يجب ألا تقل عن 8 أحرف.',
    'users_send_invite_text' => 'يمكنك اختيار إرسال دعوة بالبريد الإلكتروني إلى هذا المستخدم مما يسمح له بتعيين كلمة السر الخاصة به أو يمكنك تعيين كلمة المرور الخاصة به بنفسك.',
    'users_send_invite_option' => 'أرسل بريدًا إلكترونيًا لدعوة المستخدم',
    'users_external_auth_id' => 'ربط الحساب بمواقع التواصل',
    'users_external_auth_id_desc' => 'عند استخدام نظام مصادقة خارجي (مثل SAML2 أو OIDC أو LDAP)، يكون هذا هو المعرف الذي يربط مستخدم بوكستاك -BookStack- بحساب نظام المصادقة. يمكنك تجاهل هذا الحقل عند استخدام المصادقة الافتراضية عبر البريد الإلكتروني.',
    'users_password_warning' => 'قم بملء الحقل أدناه فقط إذا كنت ترغب في تغيير كلمة السر لهذا المستخدم.',
    'users_system_public' => 'هذا المستخدم يمثل أي ضيف يقوم بزيارة شيء يخصك. لا يمكن استخدامه لتسجيل الدخول ولكن يتم تعيينه تلقائياً.',
    'users_delete' => 'حذف المستخدم',
    'users_delete_named' => 'حذف المستخدم :userName',
    'users_delete_warning' => 'سيتم حذف المستخدم \':userName\' بشكل تام من النظام.',
    'users_delete_confirm' => 'تأكيد حذف المستخدم؟',
    'users_migrate_ownership' => 'نقل الملكية',
    'users_migrate_ownership_desc' => 'حدد مستخدم هنا إذا كنت تريد أن يصبح مستخدم آخر مالك جميع العناصر التي يمتلكها هذا المستخدم حاليا.',
    'users_none_selected' => 'لم يتم تحديد مستخدم',
    'users_edit' => 'تعديل المستخدم',
    'users_edit_profile' => 'تعديل الملف',
    'users_avatar' => 'صورة المستخدم',
    'users_avatar_desc' => 'يجب أن تكون الصورة مربعة ومقاربة لحجم 256 بكسل',
    'users_preferred_language' => 'اللغة المفضلة',
    'users_preferred_language_desc' => 'سيؤدي هذا الخيار إلى تغيير اللغة المستخدمة لواجهة المستخدم الخاصة بالتطبيق. لن يؤثر هذا على أي محتوى قد أنشائه المستخدم.',
    'users_social_accounts' => 'الحسابات الاجتماعية',
    'users_social_accounts_desc' => 'عرض حالة الحسابات الاجتماعية المرتبطة لهذا المستخدم. ويمكن استخدام الحسابات الاجتماعية بالإضافة إلى نظام التوثيق الرئيس للوصول إلى النظام.',
    'users_social_accounts_info' => 'Here you can connect your other accounts for quicker and easier login. Disconnecting an account here does not previously authorized access. Revoke access from your profile settings on the connected social account.',
    'users_social_connect' => 'ربط الحساب',
    'users_social_disconnect' => 'فصل الحساب',
    'users_social_status_connected' => 'متصل',
    'users_social_status_disconnected' => 'غير متصل',
    'users_social_connected' => 'تم ربط حساب :socialAccount بملفك بنجاح.',
    'users_social_disconnected' => 'تم فصل حساب :socialAccount من ملفك بنجاح.',
    'users_api_tokens' => 'رموز الـ API',
    'users_api_tokens_desc' => 'أنشئ وأدر رموز الوصول المستخدمة للمصادقة باستخدام واجهة برمجة تطبيقات بوكستاك رِست -BookStack REST API-. تتم إدارة صلاحيات واجهة برمجة التطبيقات بواسطة المستخدم الذي ينتمي إليه الرمز.',
    'users_api_tokens_none' => 'لم يتم إنشاء رموز API لهذا المستخدم',
    'users_api_tokens_create' => 'قم بإنشاء رمز مميز',
    'users_api_tokens_expires' => 'انتهاء مدة الصلاحية',
    'users_api_tokens_docs' => 'وثائق API',
    'users_mfa' => 'المصادقة متعددة العوامل',
    'users_mfa_desc' => 'إعداد المصادقة متعددة العوامل كطبقة إضافية من الأمان لحساب المستخدم الخاص بك.',
    'users_mfa_x_methods' => ':count طريقة مُهيأة | :count طرق مُهيأة',
    'users_mfa_configure' => 'إعداد الطرق',

    // API Tokens
    'user_api_token_create' => 'قم بإنشاء رمز API',
    'user_api_token_name' => 'الاسم',
    'user_api_token_name_desc' => 'اعطي الرمز الخاص بك اسمًا يمكن قراءته للتذكير مستقبلًا بالغرض المقصود منه.',
    'user_api_token_expiry' => 'تاريخ انتهاء الصلاحية',
    'user_api_token_expiry_desc' => 'حدد التاريخ الذي تنتهي فيه صلاحية هذا الرمز. بعد هذا التاريخ ، لن تعمل الطلبات المقدمة باستخدام هذا الرمز. سيؤدي ترك هذا الحقل فارغًا إلى تعيين انتهاء صلاحية لمدة 100 عام في المستقبل.',
    'user_api_token_create_secret_message' => 'عقب إنشاء هذا الرمز مباشرة، سيتم إنشاء "مُعرّف الرمز" و "رمز سري" وعرضهما. وسيتم عرض الرمز السري لمرة واحدة فقط ، لذا تأكد من نسخ قيمة هذا الرمز إلى مكان آمن ومضمون قبل المتابعة.',
    'user_api_token' => 'رمز الـ API',
    'user_api_token_id' => 'مُعرّف الرمز',
    'user_api_token_id_desc' => 'هذا مُعرّف تم إنشاؤه بواسطة النظام غير قابل للتحرير لهذا الرمز والذي يجب توفيره في طلبات API.',
    'user_api_token_secret' => 'الرمز السري',
    'user_api_token_secret_desc' => 'هذا الرمز السري تم إنشاؤه بواسطة النظام والذي يجب توفيره ضمن طلبات API. سيتم عرضه لمرة واحدة فقط ، لذا انسخ قيمة هذا الرمز إلى مكان آمن ومضمون.',
    'user_api_token_created' => 'تم إنشاء رمز :الوقت الزمني',
    'user_api_token_updated' => 'تم تحديث الرمز :الوقت الزمني',
    'user_api_token_delete' => 'حذف الرمز',
    'user_api_token_delete_warning' => 'سيؤدي هذا إلى حذف رمز API المُشار إليه بالكامل باسم \'اسم الرمز\' من النظام.',
    'user_api_token_delete_confirm' => 'هل أنت متأكد من أنك تريد حذف رمز API؟',

    // Webhooks
    'webhooks' => 'خطافات الويب -Webhooks-',
    'webhooks_index_desc' => 'خطافات الويب هي طريقة لإرسال البيانات إلى الروابط الخارجية عندما تحدث بعض الإجراءات والأحداث داخل النظام الذي يسمح بالتكامل القائم على الأحداث مع المنصات الخارجية مثل نظم المراسلة أو الإشعار.',
    'webhooks_x_trigger_events' => ':count حدث تشغيل |:count أحداث تشغيل',
    'webhooks_create' => 'إنشاء خطاف ويب جديد',
    'webhooks_none_created' => 'لم يتم إنشاء أي خطافات ويب حتى الآن.',
    'webhooks_edit' => 'تحرير خطاف ويب',
    'webhooks_save' => 'حفظ خطاف ويب',
    'webhooks_details' => 'تفاصيل خطاف الويب',
    'webhooks_details_desc' => 'قم بتوفير اسم سهل الاستخدام ونقطة نهاية POST كموقع لإرسال بيانات خطافات الويب إليه.',
    'webhooks_events' => 'أحداث خطفات الويب',
    'webhooks_events_desc' => 'حدد جميع الأحداث التي يجب أن تشغل هذا الرابط ليتم استدعاؤها.',
    'webhooks_events_warning' => 'ضع في اعتبارك أن هذه الأحداث سيتم تشغيلها لجميع الأحداث المحددة، حتى إذا تم تطبيق صلاحيات مخصصة. تحقق أن استخدام خطاف الويب هذا لن يكشف عن محتوى سري.',
    'webhooks_events_all' => 'جميع أحداث النظام',
    'webhooks_name' => 'اسم خطاف الويب',
    'webhooks_timeout' => 'مهلة طلب خطاف الويب (بالثواني)',
    'webhooks_endpoint' => 'نقطة نهاية خطاف الويب',
    'webhooks_active' => 'خطاف الويب فعال',
    'webhook_events_table_header' => 'الأحداث',
    'webhooks_delete' => 'حذف خطاف الويب',
    'webhooks_delete_warning' => 'سيؤدي هذا إلى حذف خطاف الويب بالكامل، الذي يحمل اسم \':webhookName\'، من النظام.',
    'webhooks_delete_confirm' => 'هل أنت متيقِّن أنك تريد حذف هذا الخطاف؟',
    'webhooks_format_example' => 'مثال على تنسيق خطاف الويب',
    'webhooks_format_example_desc' => 'يتم إرسال بيانات خطاف الويب كطلب بوست -POST- إلى نقطة النهاية المكونة كجيسون -JSON- باتباع التنسيق أدناه. خصائص "ذات صلة" و "روابط" اختيارية و ستعتمد على نوع الحدث الذي تم تشغيله.',
    'webhooks_status' => 'حالة خطاف الويب',
    'webhooks_last_called' => 'آخر اتصال:',
    'webhooks_last_errored' => 'أخر خطأ:',
    'webhooks_last_error_message' => 'رسالة الخطأ الأخيرة:',

    // Licensing
    'licenses' => 'الرخص',
    'licenses_desc' => 'هذه الصفحة تفصل معلومات الرخص لبوكستاك -BookStack- بالإضافة إلى المشاريع والمكتبات المستخدمة في بوكستاك. ولا يمكن استخدام العديد من المشاريع المدرجة إلا في سياق إنمائي.',
    'licenses_bookstack' => 'رخص بوكستاك',
    'licenses_php' => 'رخص مكتبات بي إتش بي -PHP-',
    'licenses_js' => 'رخص مكتبة جافا سكريبت -JavaScript-',
    'licenses_other' => 'رخص أخرى',
    'license_details' => 'تفاصيل الرخصة',

    //! If editing translations files directly please ignore this in all
    //! languages apart from en. Content will be auto-copied from en.
    //!////////////////////////////////
    'language_select' => [
        'en' => 'English',
        'ar' => 'العربية',
        'bg' => 'Bǎlgarski',
        'bs' => 'Bosanski',
        'ca' => 'Català',
        'cs' => 'Česky',
        'cy' => 'Cymraeg',
        'da' => 'Dansk',
        'de' => 'Deutsch (Sie)',
        'de_informal' => 'Deutsch (Du)',
        'el' => 'ελληνικά',
        'es' => 'Español',
        'es_AR' => 'Español Argentina',
        'et' => 'Eesti keel',
        'eu' => 'Euskara',
        'fa' => 'فارسی',
        'fi' => 'Suomi',
        'fr' => 'Français',
        'he' => 'עברית',
        'hr' => 'Hrvatski',
        'hu' => 'Magyar',
        'id' => 'Bahasa Indonesia',
        'it' => 'Italian',
        'ja' => '日本語',
        'ko' => '한국어',
        'lt' => 'Lietuvių Kalba',
        'lv' => 'Latviešu Valoda',
        'nb' => 'Norsk (Bokmål)',
        'ne' => 'नेपाली',
        'nn' => 'Nynorsk',
        'nl' => 'Nederlands',
        'pl' => 'Polski',
        'pt' => 'Português',
        'pt_BR' => 'Português do Brasil',
        'ro' => 'Română',
        'ru' => 'Русский',
        'sk' => 'Slovensky',
        'sl' => 'Slovenščina',
        'sv' => 'Svenska',
        'tr' => 'Türkçe',
        'uk' => 'Українська',
        'uz' => 'O‘zbekcha',
        'vi' => 'Tiếng Việt',
        'zh_CN' => '简体中文',
        'zh_TW' => '繁體中文',
    ],
    //!////////////////////////////////
];
