<?php
/**
 * Settings text strings
 * Contains all text strings used in the general settings sections of BookStack
 * including users and roles.
 */
return [

    // Common Messages
    'settings' => '设置',
    'settings_save' => '保存设置',
    'system_version' => '系统版本',
    'categories' => '类别',

    // App Settings
    'app_customization' => '个性化',
    'app_features_security' => '功能与安全',
    'app_name' => '站点名称',
    'app_name_desc' => '此名称将在网页头部和系统发送的电子邮件中显示。',
    'app_name_header' => '在网页头部显示站点名称？',
    'app_public_access' => '访问权限',
    'app_public_access_desc' => '启用此选项将允许未登录的用户访问站点内容。',
    'app_public_access_desc_guest' => '可以通过“访客”用户来控制公共访问者的访问。',
    'app_public_access_toggle' => '允许公众访问',
    'app_public_viewing' => '允许公众查看？',
    'app_secure_images' => '启用更高安全性的图片上传？',
    'app_secure_images_toggle' => '启用更高安全性的图片上传',
    'app_secure_images_desc' => '出于性能原因，所有图像都是公开的。这个选项会在图像的网址前添加一个随机的，难以猜测的字符串，从而使直接访问变得困难。',
    'app_default_editor' => '默认页面编辑器',
    'app_default_editor_desc' => '选择在编辑新页面时默认使用哪个编辑器。这可以在页面权限处覆盖。',
    'app_custom_html' => '自定义HTML头部内容',
    'app_custom_html_desc' => '此处添加的任何内容都将插入到每个页面的<head>部分的底部，这对于覆盖样式或添加分析代码很方便。',
    'app_custom_html_disabled_notice' => '在此设置页面上禁用了自定义HTML标题内容，以确保可以恢复所有重大更改。',
    'app_logo' => '站点Logo',
    'app_logo_desc' => '这会在应用程序标题栏等区域使用。此图片的高度应为 86 像素。大图像将按比例缩小。',
    'app_icon' => '应用程序图标',
    'app_icon_desc' => '此图标用于浏览器选项卡和快捷方式图标。这应该是一个 256 像素的正方形 PNG 图片。',
    'app_homepage' => '站点主页',
    'app_homepage_desc' => '选择要在主页上显示的页面来替换默认的页面，选定页面的访问权限将被忽略。',
    'app_homepage_select' => '选择一个页面',
    'app_footer_links' => '页脚链接',
    'app_footer_links_desc' => '添加在网站页脚中显示的链接。这些链接将显示在大多数页面的底部，也包括不需要登录的页面。您可以使用标签"trans::<key>"来使用系统定义的翻译。例如：使用"trans::common.privacy_policy"将显示为“隐私政策”，而"trans::common.terms_of_service"将显示为“服务条款”。',
    'app_footer_links_label' => '链接标签',
    'app_footer_links_url' => '链接 URL',
    'app_footer_links_add' => '添加页脚链接',
    'app_disable_comments' => '禁用评论',
    'app_disable_comments_toggle' => '禁用评论',
    'app_disable_comments_desc' => '在站点的所有页面上禁用评论， <br> 已有评论也不会显示出来。',

    // Color settings
    'color_scheme' => '应用程序配色方案',
    'color_scheme_desc' => '设置要在应用程序界面中使用的颜色。 可以为深色和浅色模式分别配置颜色，以适合主题并确保易读性。',
    'ui_colors_desc' => '设置应用程序的主颜色和默认链接颜色。主颜色主要用于页眉横幅、按钮和界面装饰。默认链接颜色用于基于文本的链接和操作，包括编写界面和应用程序界面。',
    'app_color' => '主颜色',
    'link_color' => '默认链接颜色',
    'content_colors_desc' => '为页面组织层次结构中的所有元素设置颜色。为了便于阅读，建议选择与默认颜色亮度相似的颜色。',
    'bookshelf_color' => '书架颜色',
    'book_color' => '书籍颜色',
    'chapter_color' => '章节颜色',
    'page_color' => '页面颜色',
    'page_draft_color' => '页面草稿颜色',

    // Registration Settings
    'reg_settings' => '注册设置',
    'reg_enable' => '启用注册',
    'reg_enable_toggle' => '启用注册',
    'reg_enable_desc' => '启用注册后，用户将可以自己注册为站点用户。 注册后，他们将获得一个默认的单一用户角色。',
    'reg_default_role' => '注册后的默认用户角色',
    'reg_enable_external_warning' => '当启用外部LDAP或者SAML认证时，上面的选项会被忽略。当使用外部系统认证认证成功时，将自动创建非现有会员的用户账户。',
    'reg_email_confirmation' => '邮件确认',
    'reg_email_confirmation_toggle' => '需要电子邮件确认',
    'reg_confirm_email_desc' => '如果使用域名限制，则需要电子邮件验证，并且该值将被忽略。',
    'reg_confirm_restrict_domain' => '域名限制',
    'reg_confirm_restrict_domain_desc' => '输入您想要限制注册的电子邮件域名列表（即只允许使用这些电子邮件域名注册），多个域名用英文逗号隔开。在允许用户与应用程序交互之前，系统将向用户发送一封电子邮件以确认其电子邮件地址。<br>请注意，用户在注册成功后仍然可以更改他们的电子邮件地址。',
    'reg_confirm_restrict_domain_placeholder' => '尚未设置限制',

    // Sorting Settings
    'sorting' => 'Lists & Sorting',
    'sorting_book_default' => 'Default Book Sort Rule',
    'sorting_book_default_desc' => '选择要应用于新书的默认排序规则。这不会影响现有书，并且可以每本书覆盖。',
    'sorting_rules' => '排序规则',
    'sorting_rules_desc' => '这些是预定义的排序操作，可应用于系统中的内容。',
    'sort_rule_assigned_to_x_books' => '分配给 :count Book|分配给 :count Books',
    'sort_rule_create' => '创建排序规则',
    'sort_rule_edit' => '编辑排序规则',
    'sort_rule_delete' => '删除排序规则',
    'sort_rule_delete_desc' => '从系统中删除这种排序规则。使用这种类型的书本将恢复到手动排序。',
    'sort_rule_delete_warn_books' => '此排序规则目前用于:count book(s)。您确定要删除吗？',
    'sort_rule_delete_warn_default' => '此排序规则目前被用作书籍的默认值。您确定要删除吗？',
    'sort_rule_details' => '排序规则详细信息',
    'sort_rule_details_desc' => '为此排序规则设置一个名称，当用户选择排序时，该名称将出现在列表中。',
    'sort_rule_operations' => '排序选项',
    'sort_rule_operations_desc' => '配置通过将它们从可用操作列表中移动来执行的排序操作。 一旦使用，操作将按顺序从上到下顺序进行。 这里所做的任何更改都将在保存时适用于所有分配的书本。',
    'sort_rule_available_operations' => '可用操作',
    'sort_rule_available_operations_empty' => '没有剩余操作',
    'sort_rule_configured_operations' => '配置选项',
    'sort_rule_configured_operations_empty' => '从“可用操作”列表中拖动/添加操作',
    'sort_rule_op_asc' => '(Asc)',
    'sort_rule_op_desc' => '(Desc)',
    'sort_rule_op_name' => '名称-按字母顺序排序',
    'sort_rule_op_name_numeric' => '名称-按数字顺序排序',
    'sort_rule_op_created_date' => '创建时间',
    'sort_rule_op_updated_date' => '更新时间',
    'sort_rule_op_chapters_first' => '章节正序',
    'sort_rule_op_chapters_last' => '章节倒序',
    'sorting_page_limits' => 'Per-Page Display Limits',
    'sorting_page_limits_desc' => 'Set how many items to show per-page in various lists within the system. Typically a lower amount will be more performant, while a higher amount avoids the need to click through multiple pages. Using an even multiple of 3 (18, 24, 30, etc...) is recommended.',

    // Maintenance settings
    'maint' => '维护',
    'maint_image_cleanup' => '清理图像',
    'maint_image_cleanup_desc' => '扫描页面和修订内容以检查哪些图片是正在使用的以及哪些图片是多余的。确保在运行前完整备份数据库和图片。',
    'maint_delete_images_only_in_revisions' => '同时删除只存在于旧的页面修订中的图片',
    'maint_image_cleanup_run' => '运行清理',
    'maint_image_cleanup_warning' => '发现了 :count 张可能未使用的图像。您确定要删除这些图像吗？',
    'maint_image_cleanup_success' => '找到并删除了 :count 张可能未使用的图像！',
    'maint_image_cleanup_nothing_found' => '找不到未使用的图像，没有删除！',
    'maint_send_test_email' => '发送测试电子邮件',
    'maint_send_test_email_desc' => '这将发送测试邮件到您的个人资料中指定的电子邮件地址。',
    'maint_send_test_email_run' => '发送测试邮件',
    'maint_send_test_email_success' => '电子邮件已发送至 :address',
    'maint_send_test_email_mail_subject' => '测试电子邮件',
    'maint_send_test_email_mail_greeting' => '邮件发送功能看起来工作正常！',
    'maint_send_test_email_mail_text' => '恭喜！您收到了此邮件通知，您的电子邮件设置看起来已配置正确。',
    'maint_recycle_bin_desc' => '被删除的书架、书籍、章节和页面会被存入回收站，您可以还原或永久删除它们。回收站中较旧的项目可能会在系统设置的一段时间后被自动删除。',
    'maint_recycle_bin_open' => '打开回收站',
    'maint_regen_references' => '重新生成引用',
    'maint_regen_references_desc' => '此操作将重建数据库中的跨项目引用索引。这通常是自动处理的，但可能有助于索引旧内容或通过非官方方法添加的内容。',
    'maint_regen_references_success' => '引用索引已重新生成！',
    'maint_timeout_command_note' => '注意：执行此操作需要一些时间，这可能会导致在某些 Web 环境中出现超时问题。作为替代方案，此操作也可以在终端中执行。',

    // Recycle Bin
    'recycle_bin' => '回收站',
    'recycle_bin_desc' => '在这里，您可以还原已删除的项目，或选择将其从系统中永久删除。与系统中过滤过的类似的活动记录不同，这个表会显示所有操作。',
    'recycle_bin_deleted_item' => '被删除的项目',
    'recycle_bin_deleted_parent' => '上级',
    'recycle_bin_deleted_by' => '删除者',
    'recycle_bin_deleted_at' => '删除时间',
    'recycle_bin_permanently_delete' => '永久删除',
    'recycle_bin_restore' => '恢复',
    'recycle_bin_contents_empty' => '回收站当前为空',
    'recycle_bin_empty' => '清空回收站',
    'recycle_bin_empty_confirm' => '这将永久性销毁回收站中的所有项目（包括每个项目中包含的内容，例如图片）。您确定要清空回收站吗？',
    'recycle_bin_destroy_confirm' => '此操作将从系统中永久删除此项目以及下面列出的所有子元素，并且您将无法还原此内容。您确定要永久删除该项目吗？',
    'recycle_bin_destroy_list' => '要销毁的项目',
    'recycle_bin_restore_list' => '要恢复的项目',
    'recycle_bin_restore_confirm' => '此操作会将已删除的项目及其所有子元素恢复到原始位置。如果项目的原始位置已被删除，并且现在位于回收站中，则要恢复项目的上级项目也需要恢复。',
    'recycle_bin_restore_deleted_parent' => '该项目的上级项目也已被删除。这些项目将保持被删除状态，直到上级项目被恢复。',
    'recycle_bin_restore_parent' => '还原上级',
    'recycle_bin_destroy_notification' => '从回收站中删除了 :count 个项目。',
    'recycle_bin_restore_notification' => '从回收站中恢复了 :count 个项目。',

    // Audit Log
    'audit' => '审核日志',
    'audit_desc' => '这份审核日志显示所有被系统跟踪的活动。与系统中过滤过的类似的活动记录不同，这个表会显示所有操作。',
    'audit_event_filter' => '事件过滤器',
    'audit_event_filter_no_filter' => '无过滤器',
    'audit_deleted_item' => '被删除的项目',
    'audit_deleted_item_name' => '名称: :name',
    'audit_table_user' => '用户',
    'audit_table_event' => '事件',
    'audit_table_related' => '相关项目或详细信息',
    'audit_table_ip' => 'IP 地址',
    'audit_table_date' => '活动日期',
    'audit_date_from' => '日期范围从',
    'audit_date_to' => '日期范围至',

    // Role Settings
    'roles' => '角色',
    'role_user_roles' => '用户角色',
    'roles_index_desc' => '角色用于对用户进行分组并为其成员提供系统权限。当一个用户是多个角色的成员时，授予的权限将叠加，用户将继承所有角色的能力。',
    'roles_x_users_assigned' => ':count 位用户已分配|:count 位用户已分配',
    'roles_x_permissions_provided' => ':count 个权限|:count 个权限',
    'roles_assigned_users' => '已分配用户',
    'roles_permissions_provided' => '已提供权限',
    'role_create' => '创建角色',
    'role_delete' => '删除角色',
    'role_delete_confirm' => '这将会删除名为 \':roleName\' 的角色.',
    'role_delete_users_assigned' => '有:userCount位用户属于此角色。如果您想将此角色中的用户迁移，请在下面选择一个新角色。',
    'role_delete_no_migration' => "不要迁移用户",
    'role_delete_sure' => '您确定要删除这个角色？',
    'role_edit' => '编辑角色',
    'role_details' => '角色详细信息',
    'role_name' => '角色名',
    'role_desc' => '角色简述',
    'role_mfa_enforced' => '需要多重身份认证',
    'role_external_auth_id' => '外部身份认证ID',
    'role_system' => '系统权限',
    'role_manage_users' => '管理用户',
    'role_manage_roles' => '管理角色与角色权限',
    'role_manage_entity_permissions' => '管理所有书籍、章节和页面的权限',
    'role_manage_own_entity_permissions' => '管理自己的书籍、章节和页面的权限',
    'role_manage_page_templates' => '管理页面模板',
    'role_access_api' => '访问系统 API',
    'role_manage_settings' => '管理 App 设置',
    'role_export_content' => '导出内容',
    'role_import_content' => '导入内容',
    'role_editor_change' => '更改页面编辑器',
    'role_notifications' => '管理和接收通知',
    'role_permission_note_users_and_roles' => 'These permissions will technically also provide visibility & searching of users & roles in the system.',
    'role_asset' => '资源许可',
    'roles_system_warning' => '请注意，拥有以上三个权限中的任何一个都会允许用户更改自己的权限或系统中其他人的权限。 请只将拥有这些权限的角色分配给你信任的用户。',
    'role_asset_desc' => '对系统内资源的默认访问许可将由这些权限控制。单独设置在书籍、章节和页面上的权限将覆盖这里的权限设定。',
    'role_asset_admins' => '管理员可自动获得对所有内容的访问权限，但这些选项可能会显示或隐藏UI选项。',
    'role_asset_image_view_note' => '这与图像管理器中的可见性有关。已经上传的图片的实际访问取决于系统图像存储选项。',
    'role_asset_users_note' => 'These permissions will technically also provide visibility & searching of users in the system.',
    'role_all' => '全部的',
    'role_own' => '拥有的',
    'role_controlled_by_asset' => '由其所在的资源来控制',
    'role_save' => '保存角色',
    'role_users' => '此角色的用户',
    'role_users_none' => '目前没有用户被分配到这个角色',

    // Users
    'users' => '用户',
    'users_index_desc' => '在系统内创建和管理个人用户账户。用户账户用于登录和内容及活动的归属。访问权限主要是基于角色的，但用户的内容所有权以及其他因素，也可能影响到权限和访问。',
    'user_profile' => '用户资料',
    'users_add_new' => '添加用户',
    'users_search' => '搜索用户',
    'users_latest_activity' => '最后活动',
    'users_details' => '用户详细资料',
    'users_details_desc' => '设置该用户的显示名称和电子邮件地址。 该电子邮件地址将用于登录本站。',
    'users_details_desc_no_email' => '设置此用户的昵称，以便其他人识别。',
    'users_role' => '用户角色',
    'users_role_desc' => '选择将分配给该用户的角色。 如果将一个用户分配给多个角色，则这些角色的权限将堆叠在一起，并且他们将获得分配的角色的所有功能。',
    'users_password' => '用户密码',
    'users_password_desc' => '设置用于登录本应用的密码。 长度必须至少为 8 个字符。',
    'users_send_invite_text' => '您可以向该用户发送邀请电子邮件，允许他们设置自己的密码，否则，您可以自己设置他们的密码。',
    'users_send_invite_option' => '发送邀请用户电子邮件',
    'users_external_auth_id' => '外部身份认证ID',
    'users_external_auth_id_desc' => '当使用外部身份验证系统（例如 SAML2、OIDC 或 LDAP）时，这是将此 BookStack 用户连接到身份验证系统账户的 ID。 如果使用默认的电子邮件身份验证，您可以忽略此字段。',
    'users_password_warning' => '如果您想更改此用户的密码，请填写以下内容：',
    'users_system_public' => '此用户代表访问您的App的任何访客。它不能用于登录，而是自动分配。',
    'users_delete' => '删除用户',
    'users_delete_named' => '删除用户 :userName',
    'users_delete_warning' => '这将从系统中完全删除名为 \':userName\' 的用户。',
    'users_delete_confirm' => '您确定要删除这个用户？',
    'users_migrate_ownership' => '迁移拥有权',
    'users_migrate_ownership_desc' => '如果您想要当前用户拥有的全部项目转移到另一个用户（更改拥有者），请在此处选择一个用户。',
    'users_none_selected' => '没有选中用户',
    'users_edit' => '编辑用户',
    'users_edit_profile' => '编辑资料',
    'users_avatar' => '用户头像',
    'users_avatar_desc' => '选择一张头像。 这张图片应该是约 256 像素的正方形。',
    'users_preferred_language' => '语言',
    'users_preferred_language_desc' => '此选项将更改用于应用程序用户界面的语言。 这不会影响任何用户创建的内容。',
    'users_social_accounts' => '社交账户',
    'users_social_accounts_desc' => '查看此用户已连接的社交账户状态。 除了主要认证系统外，社交账户也可用于系统访问。',
    'users_social_accounts_info' => '在这里，您可以绑定您的其他账户，以便更快更轻松地登录。如果您选择解除绑定，之后将不能通过此社交账户登录，请设置社交账户来取消本App的访问权限。',
    'users_social_connect' => '绑定账户',
    'users_social_disconnect' => '解除绑定账户',
    'users_social_status_connected' => '已连接',
    'users_social_status_disconnected' => '已断开连接',
    'users_social_connected' => ':socialAccount 账户已经成功绑定到您的资料。',
    'users_social_disconnected' => ':socialAccount 账户已经成功解除绑定。',
    'users_api_tokens' => 'API令牌',
    'users_api_tokens_desc' => '创建和管理用于 BookStack REST API 认证的访问令牌。 API 的权限是通过令牌所属的用户管理的。',
    'users_api_tokens_none' => '没有创建任何API令牌给此用户',
    'users_api_tokens_create' => '创建令牌',
    'users_api_tokens_expires' => '过期',
    'users_api_tokens_docs' => 'API文档',
    'users_mfa' => '多重身份认证',
    'users_mfa_desc' => '设置多重身份认证能增加您账户的安全性。',
    'users_mfa_x_methods' => ':count 个措施已配置|:count 个措施已配置',
    'users_mfa_configure' => '配置安全措施',

    // API Tokens
    'user_api_token_create' => '创建 API 令牌',
    'user_api_token_name' => '姓名',
    'user_api_token_name_desc' => '请给您的可读令牌一个命名以在未来提醒您它的预期用途',
    'user_api_token_expiry' => '过期期限',
    'user_api_token_expiry_desc' => '请设置一个此令牌的过期时间，过期后此令牌所给出的请求将失效，若将此处留为空白将自动设置过期时间为100年。',
    'user_api_token_create_secret_message' => '创建此令牌后会立即生成“令牌ID”和“令牌密钥”。该密钥只会显示一次，所以请确保在继续操作之前将密钥记录或复制到一个安全的地方。',
    'user_api_token' => 'API令牌',
    'user_api_token_id' => '令牌ID',
    'user_api_token_id_desc' => '这是系统生成的一个不可编辑的令牌标识符，需要在API请求中才能提供。',
    'user_api_token_secret' => '令牌密钥',
    'user_api_token_secret_desc' => '这是此令牌系统生成的密钥，需要在API请求中才可以提供。 这只会显示一次，因此请将其复制到安全的地方。',
    'user_api_token_created' => '创建的令牌:timeAgo',
    'user_api_token_updated' => '令牌更新:timeAgo',
    'user_api_token_delete' => '删除令牌',
    'user_api_token_delete_warning' => '这将会从系统中完全删除名为 “:tokenName” 的 API 令牌',
    'user_api_token_delete_confirm' => '您确定要删除此API令牌吗？',

    // Webhooks
    'webhooks' => 'Webhooks',
    'webhooks_index_desc' => 'Webhook 是一种在系统内发生某些操作和事件时将数据发送到外部 URL 的方法，它允许与外部平台（例如消息传递或通知系统）进行基于事件的集成。',
    'webhooks_x_trigger_events' => ':count 个触发事件 |:count 个触发事件',
    'webhooks_create' => '新建 Webhook',
    'webhooks_none_created' => '尚未创建任何 Webhook。',
    'webhooks_edit' => '编辑 Webhook',
    'webhooks_save' => '保存 Webhook',
    'webhooks_details' => 'Webhook 详情',
    'webhooks_details_desc' => '提供一个用户友好的名称和一个 POST Endpoint 作为 Webhook 数据发送的位置。',
    'webhooks_events' => 'Webhook 事件',
    'webhooks_events_desc' => '选择所有应触发此 Webhook 的事件。',
    'webhooks_events_warning' => '请记住，即使应用了自定义权限，所有选定的事件也仍然会被触发。 确保使用此 Webhook 不会泄露机密内容。',
    'webhooks_events_all' => '所有系统事件',
    'webhooks_name' => 'Webhook 名称',
    'webhooks_timeout' => 'Webhook 请求超时（秒）',
    'webhooks_endpoint' => 'Webhook Endpoint',
    'webhooks_active' => '激活 Webhook',
    'webhook_events_table_header' => '事件',
    'webhooks_delete' => '删除 Webhook',
    'webhooks_delete_warning' => '这将会从系统中完全删除名为 “:webhookName” 的 webhook。',
    'webhooks_delete_confirm' => '您确定要删除此 Webhook 吗？',
    'webhooks_format_example' => 'Webhook 格式示例',
    'webhooks_format_example_desc' => 'Webhook 数据会以 POST 请求按照以下 JSON 格式发送到设置的 Endpoint。 “related_item” 和 “url” 属性是可选的，取决于触发的事件类型。',
    'webhooks_status' => 'Webhook 状态',
    'webhooks_last_called' => '最后一次调用：',
    'webhooks_last_errored' => '最后一个错误：',
    'webhooks_last_error_message' => '最后一个错误消息：',

    // Licensing
    'licenses' => '许可证',
    'licenses_desc' => '除了 BookStack 中使用的项目和库之外，此页面还详细介绍了 BookStack 的许可证信息。列出的许多项目只能在开发环境中使用。',
    'licenses_bookstack' => 'BookStack 许可证',
    'licenses_php' => 'PHP 库许可证',
    'licenses_js' => 'JavaScript 库许可证',
    'licenses_other' => '其他许可证',
    'license_details' => '许可证细节',

    //! If editing translations files directly please ignore this in all
    //! languages apart from en. Content will be auto-copied from en.
    //!////////////////////////////////
    'language_select' => [
        'en' => 'English',
        'ar' => 'العربية',
        'bg' => '保加利亚语',
        'bs' => 'Bosanski',
        'ca' => '加泰罗尼亚语',
        'cs' => 'Česky',
        'cy' => 'Cymraeg',
        'da' => '丹麦',
        'de' => 'Deutsch (Sie)',
        'de_informal' => 'Deutsch (Du)',
        'el' => 'ελληνικά',
        'es' => 'Español',
        'es_AR' => 'Español Argentina',
        'et' => 'Eesti keel',
        'eu' => 'Euskara',
        'fa' => 'فارسی',
        'fi' => 'Suomi',
        'fr' => 'Français',
        'he' => 'עברית',
        'hr' => 'Hrvatski',
        'hu' => 'Magyar',
        'id' => 'Bahasa Indonesia',
        'it' => 'Italien',
        'ja' => '日本語',
        'ko' => '한국어',
        'lt' => 'Lietuvių Kalba',
        'lv' => 'Latviešu Valoda',
        'nb' => '挪威语 (Bokmål)',
        'ne' => 'नेपाली',
        'nn' => 'Nynorsk',
        'nl' => 'Nederlands',
        'pl' => 'Polski',
        'pt' => 'Português',
        'pt_BR' => 'Português do Brasil',
        'ro' => 'Română',
        'ru' => 'Русский',
        'sk' => 'Slovensky',
        'sl' => 'Slovenščina',
        'sv' => 'Svenska',
        'tr' => 'Türkçe',
        'uk' => 'Українська',
        'uz' => 'O‘zbekcha',
        'vi' => 'Tiếng Việt',
        'zh_CN' => '简体中文',
        'zh_TW' => '繁體中文',
    ],
    //!////////////////////////////////
];
